; 0.76.28
#autocorrect.doa off
[addon]
name=Auto Correcter

[unload]
dialogs=defcon.autocorrect.addedit defcon.autocorrect
hashtables=defcon.autocorrect
windows=@__autocorrect

[hooks]
inputquery=_replace
inputchan=_replace

#autocorrect.doa end

alias -l manifest { return $+(",$mircexe,.manifest") }
alias -l dac {
  if ($isid) { return $hget(defcon.autocorrect,$$1) }
  else { hadd -m defcon.autocorrect $1 $$2- | return }
}
alias -l dac.setup {
  if ($isid) {
    if ($1 isnum) { var %sel = $1 }
    else { var %sel = $did(defcon.autocorrect,1).sel }
    var %line = $gettok($did(defcon.autocorrect,1,%sel),2-,32)
    var %replace = $gettok($gettok(%line,1,9),5-,32)
    var %with = $gettok($gettok(%line,2,9),5-,32)
    return %replace $+ $chr(4) $+ %with
  }
  elseif ($1 == fill) {
    var %win = @__autocorrect
    close -@ %win
    window -hls %win
    var %n = $hmatch(defcon.autocorrect,replace_*,0)
    while (%n > 0) {
      var %item = $hmatch(defcon.autocorrect,replace_*,%n)
      aline %win $remove(%item,replace_) $+ $chr(9) $+ $dac(%item)
      dec %n
    }
    filter -wo %win defcon.autocorrect 1
    close -@ %win
  }
}
alias -l dac.addedit {
  dac addedit $1
  $dialog(defcon.autocorrect.addedit,defcon.autocorrect.addedit,-4)
  did -i defcon.autocorrect 1 1 headerdims autoheader:all
}
alias mdx {
  var %dll = $+(",$mircdir,etc\dlls\mdx.dll,")
  return $dll(%dll,$1,$2-)
}
alias repair-mdx {
  write -c $manifest <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
  write $manifest <assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
  write $manifest <assemblyIdentity version="1.0.0.0" processorArchitecture="X86" name="mIRC.mIRC.mIRC" type="win32"/>
  write $manifest <description>Internet Relay Chat Software</description>
  write $manifest </assembly>
}
dialog defcon.autocorrect {
  title "Autocorrecter Setup [/autocorrect]"
  size -1 -1 141 184
  option dbu
  list 1, 10 25 121 115, size extsel
  check "Enable", 2, 5 5 50 10
  button "Add", 3, 10 145 37 12
  button "Edit", 4, 52 145 37 12
  button "Delete", 5, 94 145 37 12
  button "Cancel", 6, 99 167 37 12, cancel
  button "OK", 7, 57 167 37 12, ok
  box "", 8, 5 15 131 147
}
dialog defcon.autocorrect.addedit {
  title "Autocorrect"
  size -1 -1 89 52
  option dbu
  text "Replace:", 1, 5 7 25 8
  edit "", 2, 35 5 50 10, autohs
  text "With:", 3, 5 22 25 8
  edit "", 4, 35 20 50 10, autohs
  button "OK", 5, 5 35 37 12, ok
  button "Cancel", 6, 47 35 37 12, cancel
}
on *:dialog:defcon.autocorrect.addedit:init:0: {
  var %mode = $dac(addedit)
  if (%mode == edit) {
    var %sel = $did(defcon.autocorrect,1).sel
    dac editsel %sel
    var %line = $gettok($did(defcon.autocorrect,1,%sel),2-,32)
    var %replace = $gettok($gettok(%line,1,9),5-,32)
    var %with = $gettok($gettok(%line,2,9),5-,32)
    did -a $dname 2 %replace
    did -a $dname 4 %with
  }
}
on *:dialog:defcon.autocorrect.addedit:sclick:5: {
  var %mode = $dac(addedit)
  did $iif(%mode == edit,-o,-a) defcon.autocorrect 1 $iif(%mode == edit,$dac(editsel)) $did(2) $+ $chr(9) $+ $did(4)
}
on *:dialog:defcon.autocorrect:sclick:3: { dac.addedit add }
on *:dialog:defcon.autocorrect:sclick:4: { dac.addedit edit }
on *:dialog:defcon.autocorrect:sclick:5: { did -d $dname 1 $did(1).sel }
on *:dialog:defcon.autocorrect:sclick:7: {
  var %n = $did(1).lines
  hfree defcon.autocorrect
  hmake defcon.autocorrect %n
  while (%n > 1) {
    tokenize 4 $dac.setup(%n)
    dac $+(replace_,$1) $2
    dec %n
  }
  dac enable $did(2).state
  hsave -o defcon.autocorrect usr\default\autocorrect.hsh
}
on *:dialog:defcon.autocorrect:init:0: {
  mdx SetMircVersion $version
  mdx MarkDialog $dname
  mdx SetControlMDX $dname 1 ListView headerdrag report rowselect showsel nosortheader single grid > $mircdir $+ etc\dlls\Views.mdx
  did -i $dname 1 1 headerdims 100:1 100:2
  did -i $dname 1 1 headertext + 0 Replace $+ $chr(9) $+ + 0 With
  dac.setup fill
  did -i $dname 1 1 headerdims autoheader:all
  if ($dac(enable) == 1) { did -c $dname 2 }
}
alias _replace {
  if (!$isid) { return }
  if ($dac(enable) != 1) { return $1- }
  var %n = $numtok($1-,32),%i = 1,%text
  while (%i <= %n) {
    var %item = $gettok($1-,%i,32)
    if ($dac($+(replace_,%item))) { var %text = %text $ifmatch }
    else { var %text = %text %item }
    inc %i
  }
  return %text
}
